/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <regex.h>
#include <string.h>

#include "udm_config.h"
#include "udm_common.h"
#include "udm_utils.h"
#include "udm_filter.h"
#include "udm_xmalloc.h"

/************ Allow/Disallow/CheckOnly  stuff *****************/

typedef struct filter_struct {
	regex_t filter;
	int     filter_type;
	int	flags;
	char	*regstr;
} UDM_FILTER;


__INDLIB__ int UdmFilterAdd(UDM_ENV * Conf,const char * filter,int filter_type,int flags){
	char regerrstr[128]="";
	int err;
	UDM_FILTER * Filter;

	if(Conf->Filters.nfilters>=Conf->Filters.mfilters){
		Conf->Filters.mfilters+=16;
		Conf->Filters.Filter=(UDM_FILTER *)UdmXrealloc(Conf->Filters.Filter,Conf->Filters.mfilters*sizeof(UDM_FILTER));
	}
	Filter=(UDM_FILTER*)Conf->Filters.Filter;
	Filter+=Conf->Filters.nfilters;
	
	if(flags&UDM_FILTER_REGEX){
		if(flags&UDM_FILTER_CS){
			err=regcomp(&(Filter->filter),filter,REG_EXTENDED);
		}else{
			err=regcomp(&(Filter->filter),filter,REG_EXTENDED|REG_ICASE);
		}
		if(err){
			regerror(err, &(Filter->filter), regerrstr, sizeof(regerrstr)-1);
			Conf->errcode=1;
			snprintf(Conf->errstr,sizeof(Conf->errstr),"Wrong regex in config file: %s: %s", filter,regerrstr);
			regfree(&(Filter->filter));
			return(1);
		}
	}
	Filter->filter_type=filter_type;
	Filter->flags=flags;
	Filter->regstr=strdup(filter);
	Conf->Filters.nfilters++;
	return(0);
}

int UdmFilterAddStr(UDM_ENV * Conf,char * str,int cmd){
	char *s,*lt;
	int flags=UDM_FILTER_MATCH;

	s=strtok_r(str," \t\r\n",&lt);
	while((s=strtok_r(NULL," \t\r\n",&lt))){
		if(!strcasecmp(s,"case"))flags|=UDM_FILTER_CS;
		else
		if(!strcasecmp(s,"nocase"))flags&=~UDM_FILTER_CS;
		else
		if(!strcasecmp(s,"regex"))flags|=UDM_FILTER_REGEX;
		else
		if(!strcasecmp(s,"regexp"))flags|=UDM_FILTER_REGEX;
		else
		if(!strcasecmp(s,"string"))flags&=~UDM_FILTER_REGEX;
		else
		if(!strcasecmp(s,"nomatch"))flags&=~UDM_FILTER_MATCH;
		else
		if(!strcasecmp(s,"match"))flags|=UDM_FILTER_MATCH;
		else
		if(UdmFilterAdd(Conf,s,cmd,flags))
			return(1);
	}
	return(0);
}

void UdmFilterListFree(UDM_FILTERLIST *List){
	size_t i;
	UDM_FILTER *Filter=(UDM_FILTER*)List->Filter;
	for(i=0; i < List->nfilters; i++){
		if(Filter[i].flags&UDM_FILTER_REGEX){
			regfree(&(Filter[i].filter));
		}
		free(Filter[i].regstr);
	}
	UDM_FREE(List->Filter);
	List->nfilters=List->mfilters=0;
}

#define NS 10
int UdmFilterFind(UDM_FILTERLIST *List,const char * param,char * reason){
	size_t i;
	regmatch_t subs[NS];
	int err;
	UDM_FILTER * Filter;

	Filter=(UDM_FILTER *)List->Filter;
	reason[0]=0;
	for(i=0;i<List->nfilters;i++){
		if(Filter[i].flags&UDM_FILTER_REGEX){
			err=regexec(&(Filter[i].filter),param,NS,subs,0);
		}else{
			if(Filter[i].flags&UDM_FILTER_CS){
				err=UdmStrMatch(param,Filter[i].regstr);
			}else{
				err=UdmStrCaseMatch(param,Filter[i].regstr);
			}
		}
		if((!(Filter[i].flags&UDM_FILTER_MATCH))&&(err))
			break;
		if((Filter[i].flags&UDM_FILTER_MATCH)&&(!err))
			break;
	}
	if(i<List->nfilters){
		switch(Filter[i].filter_type){
		case UDM_METHOD_GET:		strcpy(reason,"Allow");break;
		case UDM_METHOD_DISALLOW:	strcpy(reason,"Disallow");break;
		case UDM_METHOD_HEAD:		strcpy(reason,"CheckOnly");break;
		case UDM_METHOD_HREFONLY:	strcpy(reason,"HrefOnly");break;
		case UDM_METHOD_CHECKMP3ONLY:	strcpy(reason,"CheckMP3Only");break;
		case UDM_METHOD_CHECKMP3:	strcpy(reason,"CheckMP3");break;
		default:			strcpy(reason,"Unknown");break;
		}
		strcpy(UDM_STREND(reason),(Filter[i].flags&UDM_FILTER_MATCH)?"":"NoMatch");
		strcpy(UDM_STREND(reason),(Filter[i].flags&UDM_FILTER_CS)?" Case ":" NoCase ");
		strcpy(UDM_STREND(reason),(Filter[i].flags&UDM_FILTER_REGEX)?" Regex ":" ");
		strcpy(UDM_STREND(reason),Filter[i].regstr?Filter[i].regstr:"");
		return(Filter[i].filter_type);
	}
	strcpy(reason,"Allow by default");
	return(UDM_METHOD_GET);
}
